/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B?\b\u0016\u0012\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\bN\u0010OBA\u0012\u001a\u0010\r\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\bN\u0010PJ$\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003\u00a2\u0006\u0004\b\t\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00c2\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJR\u0010\u0011\u001a\u00020\u00002\u001c\b\u0002\u0010\r\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0015J\u0018\u0010 \u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b%\u0010\fR\u0013\u0010'\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\fR\u0013\u0010)\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\bR\u0011\u0010+\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\fR\u0014\u0010-\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\fR/\u0010\"\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030.j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`/8\u0006\u00a2\u0006\f\n\u0004\b\"\u00100\u001a\u0004\b1\u00102R\u0014\u00104\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\fR\u0017\u00106\u001a\u0002058\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\u0011\u0010;\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010<R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010=R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010=R+\u0010\r\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010>\u001a\u0004\b?\u0010\u0005R/\u0010@\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030.j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`/8\u0006\u00a2\u0006\f\n\u0004\b@\u00100\u001a\u0004\bA\u00102R\u0014\u0010C\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\fR\u0017\u0010D\u001a\u0002058\u0006\u00a2\u0006\f\n\u0004\bD\u00107\u001a\u0004\bE\u00109R\u0011\u0010G\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\fR\u0014\u0010K\u001a\u00020H8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0013\u0010M\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\b\u00a8\u0006Q"}, d2={"Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "Lorg/jetbrains/exposed/sql/DdlAware;", "", "Lorg/jetbrains/exposed/sql/Column;", "component1", "()Ljava/util/Map;", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "component2", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "component3", "", "component4", "()Ljava/lang/String;", "references", "onUpdate", "onDelete", "name", "copy", "(Ljava/util/Map;Lorg/jetbrains/exposed/sql/ReferenceOption;Lorg/jetbrains/exposed/sql/ReferenceOption;Ljava/lang/String;)Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "", "createStatement", "()Ljava/util/List;", "dropStatement", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "modifyStatement", "plus", "(Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;)Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "from", "targetOf", "(Lorg/jetbrains/exposed/sql/Column;)Lorg/jetbrains/exposed/sql/Column;", "toString", "getCustomFkName", "customFkName", "getDeleteRule", "deleteRule", "getFkName", "fkName", "getForeignKeyPart$exposed_core", "foreignKeyPart", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "Ljava/util/LinkedHashSet;", "getFrom", "()Ljava/util/LinkedHashSet;", "getFromColumns", "fromColumns", "Lorg/jetbrains/exposed/sql/Table;", "fromTable", "Lorg/jetbrains/exposed/sql/Table;", "getFromTable", "()Lorg/jetbrains/exposed/sql/Table;", "getFromTableName", "fromTableName", "Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "Ljava/util/Map;", "getReferences", "target", "getTarget", "getTargetColumns", "targetColumns", "targetTable", "getTargetTable", "getTargetTableName", "targetTableName", "Lorg/jetbrains/exposed/sql/Transaction;", "getTx", "()Lorg/jetbrains/exposed/sql/Transaction;", "tx", "getUpdateRule", "updateRule", "<init>", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ReferenceOption;Lorg/jetbrains/exposed/sql/ReferenceOption;Ljava/lang/String;)V", "(Ljava/util/Map;Lorg/jetbrains/exposed/sql/ReferenceOption;Lorg/jetbrains/exposed/sql/ReferenceOption;Ljava/lang/String;)V", "exposed-core"})
public final class ForeignKeyConstraint
implements DdlAware {
    @NotNull
    private final Map<Column<?>, Column<?>> references;
    @Nullable
    private final ReferenceOption onUpdate;
    @Nullable
    private final ReferenceOption onDelete;
    @Nullable
    private final String name;
    @NotNull
    private final LinkedHashSet<Column<?>> target;
    @NotNull
    private final Table targetTable;
    @NotNull
    private final LinkedHashSet<Column<?>> from;
    @NotNull
    private final Table fromTable;

    public ForeignKeyConstraint(@NotNull Map<Column<?>, ? extends Column<?>> references2, @Nullable ReferenceOption onUpdate, @Nullable ReferenceOption onDelete, @Nullable String name) {
        Intrinsics.checkNotNullParameter(references2, (String)"references");
        this.references = references2;
        this.onUpdate = onUpdate;
        this.onDelete = onDelete;
        this.name = name;
        this.target = new LinkedHashSet(this.references.values());
        this.targetTable = ((Column)CollectionsKt.first((Iterable)this.target)).getTable();
        this.from = new LinkedHashSet(this.references.keySet());
        this.fromTable = ((Column)CollectionsKt.first((Iterable)this.from)).getTable();
    }

    @NotNull
    public final Map<Column<?>, Column<?>> getReferences() {
        return this.references;
    }

    public ForeignKeyConstraint(@NotNull Column<?> target, @NotNull Column<?> from, @Nullable ReferenceOption onUpdate, @Nullable ReferenceOption onDelete, @Nullable String name) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this(MapsKt.mapOf((Pair)TuplesKt.to(from, target)), onUpdate, onDelete, name);
    }

    private final Transaction getTx() {
        return TransactionManager.Companion.current();
    }

    @NotNull
    public final LinkedHashSet<Column<?>> getTarget() {
        return this.target;
    }

    @NotNull
    public final Table getTargetTable() {
        return this.targetTable;
    }

    @NotNull
    public final String getTargetTableName() {
        return this.getTx().identity(this.targetTable);
    }

    private final String getTargetColumns() {
        return CollectionsKt.joinToString$default((Iterable)this.target, null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(this){
            final /* synthetic */ ForeignKeyConstraint this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Column<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ForeignKeyConstraint.access$getTx(this.this$0).identity(it);
            }
        }, (int)31, null);
    }

    @NotNull
    public final LinkedHashSet<Column<?>> getFrom() {
        return this.from;
    }

    @NotNull
    public final Table getFromTable() {
        return this.fromTable;
    }

    @NotNull
    public final String getFromTableName() {
        return this.getTx().identity(this.fromTable);
    }

    private final String getFromColumns() {
        return CollectionsKt.joinToString$default((Iterable)this.from, null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(this){
            final /* synthetic */ ForeignKeyConstraint this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Column<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ForeignKeyConstraint.access$getTx(this.this$0).identity(it);
            }
        }, (int)31, null);
    }

    @Nullable
    public final ReferenceOption getUpdateRule() {
        ReferenceOption referenceOption = this.onUpdate;
        if (referenceOption == null) {
            DatabaseDialect databaseDialect = DefaultKt.getCurrentDialectIfAvailable();
            referenceOption = databaseDialect == null ? null : databaseDialect.getDefaultReferenceOption();
        }
        return referenceOption;
    }

    @Nullable
    public final ReferenceOption getDeleteRule() {
        ReferenceOption referenceOption = this.onDelete;
        if (referenceOption == null) {
            DatabaseDialect databaseDialect = DefaultKt.getCurrentDialectIfAvailable();
            referenceOption = databaseDialect == null ? null : databaseDialect.getDefaultReferenceOption();
        }
        return referenceOption;
    }

    @Nullable
    public final String getCustomFkName() {
        return this.name;
    }

    @NotNull
    public final String getFkName() {
        IdentifierManagerApi identifierManagerApi = this.getTx().getDb().getIdentifierManager();
        String string = this.name;
        if (string == null) {
            string = "fk_" + this.fromTable.getTableNameWithoutScheme$exposed_core() + '_' + CollectionsKt.joinToString$default((Iterable)this.from, (CharSequence)"_", null, null, (int)0, null, (Function1)fkName.1.INSTANCE, (int)30, null) + "__" + CollectionsKt.joinToString$default((Iterable)this.target, (CharSequence)"_", null, null, (int)0, null, (Function1)fkName.2.INSTANCE, (int)30, null);
        }
        return DefaultKt.inProperCase(identifierManagerApi.cutIfNecessaryAndQuote(string));
    }

    @NotNull
    public final String getForeignKeyPart$exposed_core() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_foreignKeyPart__u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)this.getFkName())) {
            $this$_get_foreignKeyPart__u24lambda_u2d0.append("CONSTRAINT " + this.getFkName() + ' ');
        }
        $this$_get_foreignKeyPart__u24lambda_u2d0.append("FOREIGN KEY (" + this.getFromColumns() + ") REFERENCES " + this.getTargetTableName() + '(' + this.getTargetColumns() + ')');
        if (this.getDeleteRule() != ReferenceOption.NO_ACTION) {
            $this$_get_foreignKeyPart__u24lambda_u2d0.append(Intrinsics.stringPlus((String)" ON DELETE ", (Object)((Object)this.getDeleteRule())));
        }
        if (this.getUpdateRule() != ReferenceOption.NO_ACTION) {
            if (DefaultKt.getCurrentDialect() instanceof OracleDialect) {
                SQLLogKt.getExposedLogger().warn("Oracle doesn't support FOREIGN KEY with ON UPDATE clause. Please check your " + this.getFromTableName() + " table.");
            } else {
                $this$_get_foreignKeyPart__u24lambda_u2d0.append(Intrinsics.stringPlus((String)" ON UPDATE ", (Object)((Object)this.getUpdateRule())));
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.getFromTableName() + " ADD " + this.getForeignKeyPart$exposed_core()));
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        String constraintType = DefaultKt.getCurrentDialect() instanceof MysqlDialect ? "FOREIGN KEY" : "CONSTRAINT";
        return CollectionsKt.listOf((Object)("ALTER TABLE " + this.getFromTableName() + " DROP " + constraintType + ' ' + this.getFkName()));
    }

    @Nullable
    public final Column<?> targetOf(@NotNull Column<?> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        return this.references.get(from);
    }

    @NotNull
    public final ForeignKeyConstraint plus(@NotNull ForeignKeyConstraint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ForeignKeyConstraint.copy$default(this, MapsKt.plus(this.references, other.references), null, null, null, 14, null);
    }

    @NotNull
    public String toString() {
        return "ForeignKeyConstraint(fkName='" + this.getFkName() + "')";
    }

    @NotNull
    public final Map<Column<?>, Column<?>> component1() {
        return this.references;
    }

    private final ReferenceOption component2() {
        return this.onUpdate;
    }

    private final ReferenceOption component3() {
        return this.onDelete;
    }

    private final String component4() {
        return this.name;
    }

    @NotNull
    public final ForeignKeyConstraint copy(@NotNull Map<Column<?>, ? extends Column<?>> references2, @Nullable ReferenceOption onUpdate, @Nullable ReferenceOption onDelete, @Nullable String name) {
        Intrinsics.checkNotNullParameter(references2, (String)"references");
        return new ForeignKeyConstraint(references2, onUpdate, onDelete, name);
    }

    public static /* synthetic */ ForeignKeyConstraint copy$default(ForeignKeyConstraint foreignKeyConstraint, Map map2, ReferenceOption referenceOption, ReferenceOption referenceOption2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = foreignKeyConstraint.references;
        }
        if ((n & 2) != 0) {
            referenceOption = foreignKeyConstraint.onUpdate;
        }
        if ((n & 4) != 0) {
            referenceOption2 = foreignKeyConstraint.onDelete;
        }
        if ((n & 8) != 0) {
            string = foreignKeyConstraint.name;
        }
        return foreignKeyConstraint.copy(map2, referenceOption, referenceOption2, string);
    }

    public int hashCode() {
        int result2 = ((Object)this.references).hashCode();
        result2 = result2 * 31 + (this.onUpdate == null ? 0 : this.onUpdate.hashCode());
        result2 = result2 * 31 + (this.onDelete == null ? 0 : this.onDelete.hashCode());
        result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ForeignKeyConstraint)) {
            return false;
        }
        ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)other;
        if (!Intrinsics.areEqual(this.references, foreignKeyConstraint.references)) {
            return false;
        }
        if (this.onUpdate != foreignKeyConstraint.onUpdate) {
            return false;
        }
        if (this.onDelete != foreignKeyConstraint.onDelete) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)foreignKeyConstraint.name);
    }

    public static final /* synthetic */ Transaction access$getTx(ForeignKeyConstraint $this) {
        return $this.getTx();
    }
}

